#include <QSettings>
#include "GraphLegendPreference.h"
#include "unit.h"

GraphLegendPreference::GraphLegendPreference()
{
	QSettings settings;

	config_key = "graph/legend_position";

	addItem(tr("None"));
	addItem(tr("Top left"));
	addItem(tr("Top"));
	addItem(tr("Top right"));
	addItem(tr("Right"));
	addItem(tr("Bottom right"));
	addItem(tr("Bottom"));
	addItem(tr("Bottom left"));
	addItem(tr("Left"));

	setCurrentIndex(settings.value(config_key, 1).toInt());


	connect(this, SIGNAL(currentIndexChanged(int)), this, SLOT(idx_changed(int)));
}

Qt::AlignmentFlag GraphLegendPreference::getStyle(void)
{
	int flags = 0;

	switch(currentIndex()) {
		case 1: flags = Qt::AlignTop | Qt::AlignLeft; break;
		case 2: flags = Qt::AlignTop; break;
		case 3: flags = Qt::AlignTop | Qt::AlignRight; break;
		case 4: flags = Qt::AlignRight; break;
		case 5: flags = Qt::AlignBottom | Qt::AlignRight; break;
		case 6: flags = Qt::AlignBottom; break;
		case 7: flags = Qt::AlignBottom | Qt::AlignLeft; break;
		case 8: flags = Qt::AlignLeft; break;
	}

	return (Qt::AlignmentFlag)flags;
}

void GraphLegendPreference::idx_changed(int idx)
{
	QSettings settings;

	settings.setValue(config_key, idx);
	emit changed();
}
