#include <QDebug>
#include "EditButton.h"

EditButton::EditButton(const QString &text, int id, QWidget *parent) : QToolButton(parent)
{
	setText(text);
	setToolTip("Edit equation");
	setIcon(QIcon(":pencil.png"));
	buttonid = id;
	connect(this, SIGNAL(clicked()), this, SLOT(was_clicked()));

}

EditButton::EditButton(const QString &text, const QString &toolTip, int id, QWidget *parent) : QToolButton(parent)
{
	setText(text);
	setToolTip(toolTip);
	buttonid = id;
	connect(this, SIGNAL(clicked()), this, SLOT(was_clicked()));
}

EditButton::EditButton(const QString &text, const QString &toolTip, const QString &icon, int id, QWidget *parent) : QToolButton(parent)
{
	setText(text);
	setToolTip(toolTip);
	setIcon(QIcon(icon));
	buttonid = id;
	connect(this, SIGNAL(clicked()), this, SLOT(was_clicked()));
}



EditButton::~EditButton()
{
}

void EditButton::was_clicked()
{
	emit buttonIdClicked(buttonid);
}

