#ifndef _DataSourceCheckBox
#define _DataSourceCheckBox

#include <QString>
#include <QLabel>
#include <QCheckBox>
#include <QLineEdit>

#include "TChannel.h"


class DataSourceCheckBox : public QWidget
{
	Q_OBJECT

	public:
		DataSourceCheckBox(const TChannel *channel);
		virtual ~DataSourceCheckBox();	

		const QString& getChannelId() const;
		bool isChecked() const ;
		void setChecked(bool checked);

	public slots:
		void refreshAlias(const QString id, const QString alias);
		
	private slots:
		void checkChanged(int state);

	private:
		QString channelID;
		QCheckBox *checkbox;
		QLabel *lbl_alias;

};

#endif

