#ifndef _ConfigPanel_h__
#define _ConfigPanel_h__

#include <QWidget>
#include <QString>
#include <QColor>
#include <QPalette>
#include <QLabel>
#include <QSpinBox>
#include <QTimer>

#include "SelectableColor.h"
#include "ThermocoupleColorPreference.h"
#include "csv.h"
#include "virtual.h"

class ConfigPanel : public QWidget
{
	Q_OBJECT

	ConfigPanel();
	ConfigPanel(ConfigPanel const&) = delete;
	void operator=(ConfigPanel const&) = delete;

	QPalette default_palette;
	SelectableColor *sys_win_color;
	SelectableColor *sys_btn_color;
	SelectableColor *sys_base_color;
	QCheckBox *cb_use_old_sht_coefficients;
	QCheckBox *cb_disable_heat_index_validation;
	QCheckBox *cb_disable_humidex_validation;
	QCheckBox *cb_minimize_to_system_tray;
	QLabel *messageLabel;
	QDoubleSpinBox *intervalSpinBox;
	QTimer *intervalSpinBoxTimer;
	QSpinBox *display_digits;
	QSpinBox *math_channels;
	QDoubleSpinBox *ref_slp;
	int minimize_to_tray;
	CSV_Options csvopt;
	VirtualOptions virtualOptions;
	ThermocoupleColorPreference *thermocoupleColorPref;

	int interval;

	void displaySaved();

	public:

		// Singleton instance
		static ConfigPanel& instance() {
			static ConfigPanel instance;
			return instance;
		}

		virtual ~ConfigPanel();

		int getInterval();
		CSV_Options& getCSVOptions();
		VirtualOptions& getVirtualOptions();
		unit_t getUnit(unit_category_t cat);
		bool isUsingIECThermocoupleColors();

	public slots:

		void setLocked(bool locked);

	signals:

		void intervalChanged(int interval);
		void fractionalDigitsChanged(int n);
		void networkTabVisible(bool visible);
		void thermocoupleColorChanged(bool iec);
		void virtualOptionsChanged(unsigned int flags, double slp);

	private slots:

		void applyInterval();
		void onIntervalChanged(double s);
		void defaultColor(QString name);
		void setCustomColor(QString name, QColor col);
		void onColorSelected(QString name, int state, QColor col);
		void onThermocoupleColorSelected(int);
		void updateFlagsFromCheckboxes(int);
		void updateMinimizeToTray(int);
		void onDisplayDigitsChanged(int i);
		void onMathChannelsChanged(int i);
		void referencePressureChanged(double i);
		void setStandardSLP(void);
		void autoSetSLP(void);
		void showNetworkTab(bool visible);

};

#endif // _ConfigPanel_h__
