#ifndef _ConfigComboBox_h__
#define _ConfigComboBox_h__

#include <QComboBox>
#include <QStringList>


class ConfigComboBox : public QComboBox {

    Q_OBJECT

    const QString key;

    public:

        ConfigComboBox(const QString& key, const QStringList& items, int defaultIndex = 0);
        virtual ~ConfigComboBox();

    protected slots:

        virtual void onChange(int index);        

};

class FieldSeparatorComboBox : public ConfigComboBox {

    static const char *values[];

    public:

        FieldSeparatorComboBox();
    
    protected:

        virtual void onChange(int index);

};

class DecimalPointComboBox : public ConfigComboBox {

    public:

        DecimalPointComboBox();
    
    protected:

        virtual void onChange(int index);

};

class TimeFormatComboBox : public ConfigComboBox {

    static const int8_t values[];

    public:

        TimeFormatComboBox();
    
    protected:

        virtual void onChange(int index);

};

class ErrorStringComboBox : public ConfigComboBox {

    static const char *values[];

    public:

        ErrorStringComboBox();
    
    protected:

        virtual void onChange(int index);

};


#endif
