#ifndef _calibration_edit_dialog_dxc220_h__
#define _calibration_edit_dialog_dxc220_h__


#include <QDialog>
#include <QLabel>
#include <QPushButton>
#include <QLineEdit>
#include <QTimer>
#include <QString>


class CalibrationEditDialog_DXC220 :  public QDialog
{
    Q_OBJECT

	public:
		CalibrationEditDialog_DXC220(QWidget *parent = 0, const QString& serialNumber = "", const bool localTenkinet = false);
        virtual ~CalibrationEditDialog_DXC220();

	private slots:
		void applyClose();
		void stopDotsAndClose();

	private:
		const QString serialNumber;
		const bool localTenkinet;
		QLineEdit *concentrationEdit;
		QPushButton *btn_ok;
		QPushButton *btn_cancel;

		QTimer *dotsTimer;
		int dotCount;
		QString originalOkText;


};

#endif
