#ifndef _calibration_edit_dialog_h__
#define _calibration_edit_dialog_h__


#include <QDialog>
#include <QPushButton>
#include <QLineEdit>
#include <QLabel>
#include <QCheckBox>
#include <QList>
#include <QDoubleValidator>
#include <QString>
#include <QTimer>

#include "TChannel.h"
#include "EditButton.h"


class CalibrationEditDialog : public QDialog
{
	Q_OBJECT

	public:
		CalibrationEditDialog(QWidget *parent = 0, const QString& channelID = "");
		virtual ~CalibrationEditDialog();

		bool calibrationDisabled();

	private slots:
		void refresh();
		void applyClose();
		void clearPointClicked(int);

	protected:
		virtual void showEvent(QShowEvent *event);
		void stopDotsAndClose();

	private:

		const QString channelID;

		QList<QLabel*> lbl_points;
		QList<QLabel*> lbl_units_sensed;
		QList<QLabel*> lbl_units_calibrated;
		QList<QLineEdit*> lst_le_sensed;
		QList<QLineEdit*> lst_le_calibrated;
		QList<EditButton*> lst_clear_buttons;
		QLabel *lbl_sensed;
		QLabel *lbl_calibrated;
		QCheckBox *cb_disable;
		QPushButton *btn_ok, *btn_cancel;

		bool calibration_disabled;
		const QString calibration_disabled_key;

		QTimer *dotsTimer;
		int dotCount;
		QString originalOkText;

};


#endif // _calibration_edit_dialog_h__

