#ifndef _bigview_h__
#define _bigview_h__

#include <QWidget>
#include <QString>
#include <QHash>

#include "BigLabel.h"
#include "TDevice.h"


class BigView : public QWidget
{
	Q_OBJECT

	public:

        // Singleton instance
        static BigView& instance() {
            static BigView instance;
            return instance;
        }

        // Disable copy constructor and assignment operator
        // Required to enforce singleton pattern
        BigView(BigView const&) = delete;
        void operator=(BigView const&) = delete;
		
		virtual ~BigView();

	public slots:

        void refreshDevice(const TDevice *device);

		void addChannel(const QString& id);
		void removeChannel(const QString& id);

	private:

		BigView();

        void subscribe(const TDevice *device);
        void unsubscribe(const TDevice *device);
		
        QHash<QString, BigLabel*> labelByChannel;

};

#endif 

