#include <QTextEdit>
#include <QFile>
#include "About.h"
#include "usbtenki_version.h"

#define HOMEPAGE	"https://www.dracal.com"

About::About()
{
	QTextEdit *te;
	lay = new QVBoxLayout();

	setLayout(lay);

	te = new QTextEdit();
	te->setReadOnly(true);

	lay->addWidget(te);
	
	te->setHtml(
"<h1>DracalView " USBTENKI_VERSION "</h1>"
"Previously known as QTenki<br><br>"
USBTENKI_COPYRIGHTS_HTML "<br><br>"
"Visit <a href='" HOMEPAGE "'>" HOMEPAGE "</a> for the latest releases."
"<br>"
"<hr>"
"<h1>License</h1>"
"<br>"
"This software is free software: you can redistribute it and/or modify it under the<br>"
"terms of the GNU General Public License as published by the Free Software Foundation,<br>"
"either version 3 of the License, or (at your option) any later version.<br>"
"<br>"
"This software is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;<br>"
"without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.<br>"
"See the GNU General Public License for more details.<br>"
"<br>"
"This software uses Qt 5, which can be found at <a href='https://www.qt.io'>https://www.qt.io</a><br>"
"Qt is Copyright (C) 2018 The Qt Company.<br>"
"Qt is licensed under the GNU Lesser General Public License (LGPL), version 3.<br>"
"You can find a copy of this license at <a href='https://www.gnu.org/licenses/lgpl-3.0.en.html'>https://www.gnu.org/licenses/lgpl-3.0.en.html</a><br>"
"<br>"
"This software uses QCustomPlot, which can be found at <a href='http://www.qcustomplot.com'>http://www.qcustomplot.com</a><br>"
"QCustomPlot is Copyright (C) 2011-2021 Emanuel Eichhammer.<br>"
"QCustomPlot is licensed under the GNU General Public License (GPL), version 3. See below.<br>"
"<br>"
"This software uses libusb, which can be found at <a href='https://libusb.info'>https://libusb.info</a><br>"
"libusb is Copyright (C) 2001 Johannes Erdfelt &lt;johannes@erdfelt.com&gt;, and other contributors.<br>"
"libusb is licensed under the GNU Lesser General Public License (LGPL), version 2.1.<br>"
"You can find a copy of this license at <a href='https://www.gnu.org/licenses/lgpl-2.1.en.html'>https://www.gnu.org/licenses/lgpl-2.1.en.html</a><br>"
"<br>"
);

	QFile *file = new QFile(":gpl.txt");
	if (file->open(QIODevice::ReadOnly | QIODevice::Text)) {
		while (!file->atEnd()) {
			QByteArray line = file->readLine();
			te->append(line.trimmed());
		}
		file->close();
	}
}

About::~About()
{
}
